﻿using Hl7.Fhir.Model;
using Hl7.Fhir.Serialization;
using System.Linq;
using VA.PPMS.IWS.Common;
using VA.PPMS.ProviderData;

namespace VA.PPMS.IWS.Api.Helpers
{
    internal static class FhirHelper
    {
        public const string AllOk = "allok";
        public const string Exception = "exception";

        public static Bundle ConvertToBundle(string fhirJson)
        {
            var parser = new FhirJsonParser(new ParserSettings { AcceptUnknownMembers = true, AllowUnrecognizedEnums = true, DisallowXsiAttributesOnRoot = false });
            return parser.Parse<Bundle>(fhirJson);
        }

        public static OperationOutcome ConvertToOutcome(string fhirJson)
        {
            var parser = new FhirJsonParser(new ParserSettings { AcceptUnknownMembers = true, AllowUnrecognizedEnums = true, DisallowXsiAttributesOnRoot = false });
            return parser.Parse<OperationOutcome>(fhirJson);
        }

        public static string ExtractUrl(Bundle bundle)
        {
            var content = ExtractFirstContent(bundle);
            return !string.IsNullOrEmpty(content?.Attachment?.Url) ? content.Attachment.Url : string.Empty;
        }

        public static Providers ExtractProviders(Bundle bundle)
        {
            var content = ExtractFirstContent(bundle);
            if (content?.Attachment?.DataElement == null) return null;
            var result = Utilities.Base64Decode(content.Attachment.DataElement.Value);

            return Utilities.Deserialize<Providers>(result);
        }

        public static DocumentReference.ContentComponent ExtractFirstContent(Bundle bundle)
        {
            if (bundle.Entry.Count == 0) return null;
            if (bundle.Entry[0].Resource is DocumentReference docRef) return docRef.Content.FirstOrDefault();

            return null;
        }
    }
}